#pragma once
//#define ITP_DATA_SIZE (640*480*3)
#define ITP_DATA_SIZE (400*300)
#define POOL_ITP_COUNT 200
#define ZKFPV10_MAX_LEN 1664
#include <deque>
#include "AxMutex.h"
class CMemPool;

#ifndef U8 
#define U8 unsigned char 
#endif 


#ifndef U32 
#define U32 unsigned int
#endif
#ifndef U16 
#define U16 unsigned short
#endif

#define HEADER_NUM  13
#define DELETE_ONLY_ONE	        0x77


#define MS_IDLE				0x00	//
#define MS_ENROLL			0x01	//
#define MS_VERIFY			0x02	//
#define MS_BUSY				0x04	//

#define MD_SYS_WP				0x11	//write
#define MD_SYS_SP				0x12	//save
#define MD_SYS_RP				0x13 
#define MD_SYS_STATUS			0x14
#define MD_ENROLL_SCAN		    0x15
#define MD_ENROLL_TMP			0x17
#define MD_VERIFY_SCAN			0x18
#define MD_CONTINUE				0x74
#define MD_CANCEL_OP			0x78
#define MD_ADD_NEW			    0x71
#define MD_DEL_TMP				0x26
#define MD_DEL_ALL_TMP			0x27
#define MD_IDENTIFY_FREE		0x2f
#define MD_DEL_DB				0xF8
#define MD_ENROLL_IMAGE_X	    0x80
#define MD_DELETE_USER			0xF3
#define MD_DEL_ALL_USER			0xF5
#define MD_IDENTIFY_IMAGE_X		0x81
#define MD_SCAN_IMAGE_X			0x83
#define MD_VERIFY_TMP_H_X		0x8E
#define MD_ADD_USER				0xF1
#define MD_READ_USER			0xF2
#define MD_LOAD_USER_X			0xA0
#define MD_LOAD_TMP_X			0xA2
#define MD_READ_TMP_X			0x89
#define MD_DEL_ALOG				0x9E
#define MD_LOAD_LOG_X			0xA4
#define MD_UPDATA				0x72
#define MD_DISCONNECT			0xCC
#define MD_RESET				0xD0
#define MD_SCAN_TEMPLATE		0xFC  //ɨģ


#define MD_GET_TIME				0x4B
#define MD_SET_TIME				0x4A

#define SID_TIMEOUT			0x62	//time ou	
#define SID_SAVE_LOG		0x36	// save log	
#define SID_AUTO_ACK		0x82	// auto response when free scan
#define SID_FW_VER			0x6E	//firmware version
#define SID_BAUDRATE		0x71	//baudrate 57600
#define SID_ENROLL_FP		0x73	//Current number of Enrolled fp
#define SID_FP_COUNT		0x74	// the available number of fp that can  be enrolled
#define SID_USER_COUNT		0x79	//Max user count
#define SID_LOG_NUM			0x7C	//Log number
#define SID_LOG_COUNT		0x7B	//maximum Log Count
#define SID_BUILD_NUM		0x89	//builed number
#define SID_MODULE_ID		0x6D	//module id
#define SID_WORKMODE		0x50	//work mode
#define SID_TEMPLATEFMT		0x51    //ģʽʽ0-ZK1-ISO


#define SID_GPIO_LEVEL		0x31	// GPIO level

#define MD_SUCCESS			0x61
#define MD_TIME_OUT			0x6C
#define MD_NOT_FIND			0x69

// Extended data transfer
#define MD_EXT_DATA					0x80
#define MD_DATA_ERROR				0x82
#define MD_DATA_OK					0x83

#define FP_ONE_SIZE		2048

typedef struct _options_
{
	int EnrollMode;
	int SecLevel;
	int ImageFormat;
	int DeviceID;
	int EnrolledFP;
	int FPCount;
	int EnrolledUser;
	int UserCount;
	int LogNum;
	int LogCount;
	int SendFP;
	int FreeScan;
	int WdtOn;
	int MatchTime;
	int Enrolltmp;
	int timeout;
	int FPWav;
	int FWVer;
	int SerialNum;
	int BuiledDate;
	int AutoResponse;
	int SaveAttLog;
	int VoiceOn;
	int EncryOn;
	int BaudRate;
	int FreeScanDelay;
	int Vol;
	int LogDelay;
	int EmptyPrivAll;
	int GPIOLevel;
	int NetWorkMode;
	int DataSecMode;
	int ResDelay;
	int AscII;
	int ImageQo;
	int Rotation;
	int PassEmpty;
	int EnrollMove;
	int FastMode;
	int SensorType;
	int RotateImage;
	int Light;
	int Sensitivity;
	int CheckFp;
	int TmpSize;
	int FPVersion;
}TOptions, *POptions;

#define IMAGE_LENGTH   400*400
typedef struct _Image_{
	int width;
	int heigth;
	int compressed;
	int encrypted;
	int binary;
	int img_len;
	int template_len;
	char ImageBuf[IMAGE_LENGTH];
}TImage, *PImage;


#pragma pack(1)
typedef struct _RSHeader_
{
	char Startcode;
	char Command;
	int Param;
	int Size;
	char Flag;
	char CheckSum;
	char Endcode;
} TRSHeader, *PRSHeader;

typedef struct _Template_{
	U16 Size;
	U16 PIN;
	BYTE FingerID;
	BYTE Valid;
	BYTE Template[ZKFPV10_MAX_LEN]; //maximize template length
} TTemplate, *PTemplate;

typedef struct _MAttLog_{
	BYTE Event;
	BYTE verified;
	U32 Date;
	U32 Time;
	U16 PIN;
	int Reserved;
}TMAttLog, *PMAttLog;

typedef struct _ExtHeader_
{
	char  Startcode;
	char  Command;
	short  PacketNum;
	short  Index;
	int 	  Size;
	char  Flag;
	char  CheckSum;		
	char  EndCode;
} TExtHeader, *PExtHeader;

typedef struct _User_{
	U16 PIN;		//User ID
	U8 Privilege;
	U8 Fpnum;		//ûǼǵָ
	U16 SecLevel;		//ûܵȼ 0 1 11
	U32 PIN2;		//32λûڶʶ	
	char Name[8];
	char Password[5];
	U8 Card[5];		//룬ڴ洢ӦIDĺ
} TUser, *PUser; 

typedef struct DevParam
{
	int saveLog;
	int timeOut;
	int autoACK;
	int fwVer;
	int baudrate;
	int enrollFp;
	int fpCount;
	int userCount;
	int logNum;
	int logCount;
	int buildTime;
	int moduleID;
	int workMode;
	int tmpFormat;
} *PDevParam;

typedef struct SetParam
{
	int iGpioLevel;
	int iSaveLog;
	int iAutoAck;
	int iTimeout;
	int iWorkMode;
	int iTmpFormat;
	int iLampColor;
	int iLampTime;
}*PSaveParam;

typedef enum
{
	EVENT_REQUEST,
	EVENT_RESPONSE,
	EVENT_NOTICE
}ITP_EVENT;

typedef enum
{
	CENTER_MODULE,
	USB_MODULE,
	USER_MODULE,
	FILE_MODULE,
}ITP_MODUEL;

typedef enum
{
	OP_INVALID_OPERATION,
	OP_CONNECT,
	OP_DIS_CONNECT,
	
	OP_ENROLL,
	OP_ENROLLING,
	OP_ENROLL_SUCCESS,
	OP_ENROLL_FAILURE,
	OP_ENROLL_IMAGE,
	OP_ENROLL_TMP,

	OP_START_READ_DATA,
	OP_READ_DATA,
	OP_STOP_READ_DATA,
	
	OP_DEL_TMP,
	OP_LOAD_TMP,
	OP_READ_TMP,

	OP_DEL_USER,
	OP_ADD_USER,
	OP_READ_USER,
	OP_LOAD_USER,
	OP_DEL_DB,

	OP_VERIFY,
	
	OP_LOAD_LOG,
	OP_DEL_LOG,
	OP_SET_TIME,
	OP_GET_TIME,
	OP_SYS_STATUS,
	OP_SYS_READ_PARAM,
	OP_SYS_WRITE_PARAM,
	OP_SYS_SAVE_PARAM,

	OP_SCAN_IMAGE,
	OP_SCAN_TMP,

	OP_UPDATA,
	OP_RESET,

	NOTICE_IDENTIFY,

	OP_WRITE_DATA,
}ITP_OPERATION;

typedef enum
{
	Result_OK,
	Result_Error,
	Result_hasOpened,
	Result_SendFail,
	Result_NoReply,
	Result_NoSuccess,
	Result_NoFind,
	Result_CheckSum,
	Result_DataError,
	Result_PackNumError,
}OP_Result;

class CInterProtocl
{
public:
	CInterProtocl();
	virtual ~CInterProtocl();
public:
	int PushData(char *data, int len);
	void recycleITP();
public:
	int m_nParam1;
	int m_nParam2;
	int m_nParam3;
	char m_data[ITP_DATA_SIZE];
	int m_len;
	static CMemPool *m_pool;
public:
	char *m_dataEx;
	int m_lenEx;
public:

	ITP_MODUEL m_srcModule;				//Դģ
	ITP_MODUEL m_desModule;				//Ŀģ
	ITP_EVENT m_eventType;				//¼
	ITP_OPERATION m_operation;			//
	OP_Result m_Reslut;					//
};

class CMemPool
{
public:
	CMemPool();
	virtual ~CMemPool();
public:
	CInterProtocl *GetIdleITP();
	void recycleITP(CInterProtocl *pItp);
	int getIdleCount();
private:
	std::deque<CInterProtocl *> m_itpQueue;
	CAxMutex mutex;
};

class IMsgListener
{
public:
	virtual void onMsgPdu(CInterProtocl *pdu) = 0;
};

class IResultListener
{
public:
	virtual void onResult(OP_Result result, ITP_OPERATION operation, char *data, int len, int nParam1=0, int nParam2=0, int nParam3=0) = 0;
};